package w83a.w83aUtilidadesComunes;

import java.io.IOException;
import java.io.InputStream;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

import es.ejie.frmk.listeners.base.Q70ListenerUtils;

public final class W83aClsConstantes {
	
	/**
	 * 
	 */
	private W83aClsConstantes(){}
	
	 //Constantes del contexto
    public static final String CONSTANTE_CONTEXTO_IDIOMA="w83aCgaIdioma";
    public static final String CONSTANTE_CONTEXTO_USUARIO="w83aUsuarioXLNets";
    public static final String CONSTANTE_MENSAJES_APLICACION_NO_ERROR="w83amensajesAplicacionnoError";

	//Constantes Idioma
	public static final String CONSTANTE_CASTELLANO = "es";
	public static final String CONSTANTE_EUSKARA = "eu";
	public static final String CONSTANTE_INGLES = "en";
	public static final String CONSTANTE_CASTELLANO_XLNETS = "1";
	public static final String CONSTANTE_EUSKARA_XLNETS = "3";
	
	//CDIGOS PROVINCIAS CAV	
	public static final String CONSTANTE_ALAVA = "01";
	public static final String CONSTANTE_BIZKAIA = "48";
	public static final String CONSTANTE_GIPUZKOA = "20";
	public static final String CONSTANTE_SERVICIOS_CENTRALES = "99";
	public static final String CONSTANTE_CAV = "16";
	public static final String[] LISTADO_PROVINCIAS_W83B = new String[]{
		CONSTANTE_ALAVA,CONSTANTE_GIPUZKOA,
		CONSTANTE_BIZKAIA,CONSTANTE_BIZKAIA
};
	
	
	//PERMISOS VIEJOS
	public static final String CONSTANTE_PERMISO_DELEGACION_ALAVA = "W83B-PF-0001";
	public static final String CONSTANTE_PERMISO_DELEGACION_BIZKAIA = "W83B-PF-0048";
	public static final String CONSTANTE_PERMISO_DELEGACION_GIPUZKOA = "W83B-PF-0020";
	public static final String CONSTANTE_PERMISO_SERVICIOS_CENTRALES = "W83B-PF-0099";
	//fin PERMISOS VIEJOS
	
	//PERMISOS
	public static final String CONSTANTE_PERMISO_ADMOM_DIR_TRAB_SS_SERVCENTRALES = "W83B-PF-0003";
	
	public static final String CONSTANTE_PERMISO_ADMINISTRADOR_ALAVA = "W83B-PF-0004";
	public static final String CONSTANTE_PERMISO_CONSULTA_ALAVA = "W83B-PF-0005";
	
	public static final String CONSTANTE_PERMISO_ADMINISTRADOR_GUIPUZKOA = "W83B-PF-0006";
	public static final String CONSTANTE_PERMISO_CONSULTA_GUIPUZKOA = "W83B-PF-0007";
	
	public static final String CONSTANTE_PERMISO_ADMINISTRADOR_BIZKAIA = "W83B-PF-0008";
	public static final String CONSTANTE_PERMISO_CONSULTA_BIZKAIA = "W83B-PF-0009";
	
	public static final String PERMISO_ADMINISTRADOR = "1";
	public static final String PERMISO_CONSULTA = "2";
	
	//Constantes para campos nulos
	public final static String NULL_DOUBLE = "NULL_DOUBLE";
	public final static String NULL_STRING = "NULL_STRING";
	public final static String NULL_INTEGER = "NULL_INTEGER";
	public final static String NULL_FLOAT = "NULL_FLOAT";
	public final static String NULL_DATE = "NULL_DATE";
	public final static String NULL_BLOB = "NULL_BLOB";

	
    
	//VARIABLES DE LA REQUEST RIA
	public static final String RIA_PAGINA_ACTUAL = "page";
	public static final String RIA_FILAS_PAGINA = "rows";
	public static final String RIA_IDCOLUMNAORDENAR = "sidx";
	public static final String RIA_DIRECCIONORDENACION = "sord";
	public static final String RIA_SEARCH = "_search";
	
	   /** The Constant CUARENTA. */
    public static final int CUARENTA = 40;
    public static final int SIETE = 7;
    public static final int SEIS = 6;
    public static final int TRESCIENTOS = 300;
    
  //Modos de pantalla
	public static final String MODO_ALTA="A";
	public static final String MODO_EDICION="E";
	public static final String MODO_BUSQUEDA="B";
	public static final String MODO_BUSQUEDA_CONBUSQ_INICIAL="B_I";
	
	//Contantes generales
	public static final String CONSTANTE_SI="S";
	public static final String CONSTANTE_NO="N";
	
	//Constante String para la fecha
	public static final String FORMATO_FECHA_CASTELLANO="DD/mm/YYYY";
	public static final String FORMATO_FECHA_EUSKARA="YYYY/mm/DD";
	public static final String FORMATO_FECHA="YYYYmmDD";
	public static final String FORMATO_FECHA_COMPLETA_CASTELLANO="DD/mm/YYYY HH24:MI:SS";
	public static final String FORMATO_FECHA_COMPLETA_EUSKARA="YYYY/mm/DD HH24:MI:SS";

	public static final String FORMATO_FECHA_CASTELLANO_PARSER="dd/MM/yyyy";
	public static final String FORMATO_FECHA_EUSKARA_PARSER="yyyy/MM/dd";
	public static final String FORMATO_FECHA_PARSER="yyyymmdd";
	public static final String FORMATO_FECHA_COMPLETA_CASTELLANO_PARSER="dd/MM/yyyy hh:mm:ss";
	public static final String FORMATO_FECHA_COMPLETA_EUSKARA_PARSER="yyyy/MM/dd hh:mm:ss";
	
	public static final String FORMATO_HORA="hh24:mI:ss";
	//CDIGOS CIF/NIF/OTROS
	public static final String CONSTANTE_CIF = "0";
	public static final String CONSTANTE_NIF = "1";
	public static final String CONSTANTE_OTROS = "2";
	//TIPO REGISTRO JURDICO
	public static final String REGISTRO_JURIDICO_PERSONAL = "1";
	public static final String REGISTRO_JURIDICO_OTROS = "2";
	
	//VARIABLES ALTA/BAJA REGISTRO BD
	public static final String ALTA="A";
	public static final String BAJA="B";
	
	public static final String CONSTANTE_DESCRIP_ESPECIALISTAS = "ESP";
	public static final String CONSTANTE_DESCRIP_TECNICOS = "TEC";
	
	//SEXO
	public static final String CONSTANTE_VARON = "H";
	public static final String CONSTANTE_MUJER = "M";
	
	//TIPO DE ACTA
	public static String TIPO_ACTA_PARCIALES = "P";
	public static String TIPO_ACTA_TOTALES = "T";
	public static String INSPECCIONADA = "1";
	public static String NO_INSPECCIONADA = "0";
	
	
    
    /** The Constant ZERO. */
    public static final int ZERO = 0;
    /** The Constant UNO. */
    public static final int UNO = 1;
    /** The Constant DOS. */
    public static final int DOS = 2;
    /** The Constant CUATRO. */
    public static final int CUATRO = 4;
    /** The Constant CINCO. */
    public static final int CINCO = 5;
    /** The Constant ONCE. */
    public static final int ONCE = 11;
    /** The Constant DOCE. */
    public static final int DOCE = 12;
    /** The Constant DIEZYNUEVE. */
    public static final int DIEZYNUEVE = 19;
	/** The Constant VEINTE. */
    public static final int VEINTE = 20;
    /** The Constant NOVENTAYNUEVE. */
    public static final int NOVENTAYNUEVE = 99;
    /** The Constant VACIO. */
	public static final String VACIO= "";
    
   public static final String CONSTANTE_ESPECIALISTAS_NOCUALIFICADOS_NUM = "1";
	public static final String CONSTANTE_TECNICOS_ADMINISTRATIVOS_NUM = "0";
	
	public static final String CONSTANTE_DESCARTADA = "2";
	public static final String CONSTANTE_VALIDADA = "1";
	public static final String CONSTANTE_NO_VALIDADA = "0";
	
	//TIPOS INCIDENCIA
	public static final String CONSTANTE_SUSTITUCION = "1";
	public static final String CONSTANTE_DIMISION = "2";
	public static final String CONSTANTE_BAJA = "3";
	public static final String CONSTANTE_FALLECIMIENTO = "4";
	public static final String CONSTANTE_REVOCACION = "5";
	public static final String CONSTANTE_ACTA_PARCIAL = "6";
	public static final String CONSTANTE_SUBSANACION = "7";
	public static final String CONSTANTE_OTROS_TIPOS_INCIDENCIA = "99";
	
	
	public static final String ETIQUETADOCUMENTO ="ejgvDocument";
	public static final String ETIQUETATEXTOAFIRMAR ="ejgvSignedInfo";
	public static final String ETIQUETAFIRMAINICIO ="ejgvSignatureFooterBegin";
	public static final String ETIQUETAFIRMAFIN ="ejgvSignatureFooterEnd";
	
	public static final String ENTRADA ="E";
	public static final String SALIDA ="S";
	public static final String PREFIJO_FICHERO_VUELTA="preavisoEJ";
	public static final String IDA = "0";
	public static final String VUELTA = "1";
	
	
	public static final String ADMINISTRADOR = "1";
	public static final String FUNCIONARIO = "2";
	public static final String SINDICATO = "3";
	
	public static final String XLNETS_APLICATIONSESSIONTOKEN = Q70ListenerUtils.getApplicationProperty("w83a_applicationSessionToken");
	public static final String XLNETS_PERSONTYPE = Q70ListenerUtils.getApplicationProperty("w83a_personType");
	
	public static final String ELA = "ELA";
	public static final String CCOO = "CCOO";
	public static final String UGT = "UGT";
	public static final String LAB = "LAB";
	public static final String USO = "USO";
	public static final String CUIS = "CUIS";
	public static final String CTI = "CTI";
	public static final String CSI = "CSI";
	public static final String NOSIN = "NOSIN";
	
	private static String codELAtemp = null;
	private static String codCCOOtemp = null;
	private static String codUGTtemp = null;
	private static String codLABtemp = null;
	private static String codUSOtemp = null;
	private static String codCUIStemp = null;
	private static String codCTItemp = null;
	private static String codCSItemp = null;
	private static String codNOSINtemp = null;

	public static String codELA = (codELAtemp==null)?getinic(ELA):codELAtemp;
	public static String codCCOO = (codCCOOtemp==null)?getinic(CCOO):codCCOOtemp;
	public static String codUGT = (codUGTtemp==null)?getinic(UGT):codUGTtemp ;
	public static String codLAB = (codLABtemp==null)?getinic(LAB):codLABtemp;
	public static String codUSO = (codUSOtemp==null)?getinic(USO):codUSOtemp;
	public static String codCUIS = (codCUIStemp==null)?getinic(CUIS):codCUIStemp;
	public static String codCTI = (codCTItemp==null)?getinic(CTI):codCTItemp;
	public static String codCSI = (codCSItemp==null)?getinic(CSI):codCSItemp;
	public static String codNOSIN = (codNOSINtemp==null)?getinic(NOSIN):codNOSINtemp;
	
	public static String  VARIOS_SINDICATOS_PROMOTORES = "999";
	
	
	public static String getinic(String nomsindicato){		
		DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
		DocumentBuilder docBuilder=null;
		try {
			docBuilder = docBuilderFactory.newDocumentBuilder();
		} catch (ParserConfigurationException e) {
		
			W83aClsTrazas.trazaError(null,e.getLocalizedMessage(),e);
		}
		Document doc=null;
		try {
			InputStream input = W83aClsConstantes.class.getResourceAsStream("/html/datos/xml/w83aDatosComunes.xml");
			doc = (Document)docBuilder.parse(input);
		} catch (SAXException e) {
		
			W83aClsTrazas.trazaError(null,e.getLocalizedMessage(),e);
		} catch (IOException e) {
			
			W83aClsTrazas.trazaError(null,e.getLocalizedMessage(),e);
		}
		String querie;
		NodeList nodeNOMBRE=null;
		try {
			querie = "//parent::XML/SINDICATOS/"+ELA+"/text()";
			codELAtemp = (XPathAPI.selectNodeList(doc, querie)).item(0).getNodeValue();
			querie = "//parent::XML/SINDICATOS/"+CCOO+"/text()";
			codCCOOtemp = (XPathAPI.selectNodeList(doc, querie)).item(0).getNodeValue();
			querie = "//parent::XML/SINDICATOS/"+UGT+"/text()";
			codUGTtemp = (XPathAPI.selectNodeList(doc, querie)).item(0).getNodeValue();
			querie = "//parent::XML/SINDICATOS/"+LAB+"/text()";
			codLABtemp = (XPathAPI.selectNodeList(doc, querie)).item(0).getNodeValue();
			querie = "//parent::XML/SINDICATOS/"+USO+"/text()";
			codUSOtemp = (XPathAPI.selectNodeList(doc, querie)).item(0).getNodeValue();
			querie = "//parent::XML/SINDICATOS/"+CUIS+"/text()";
			codCUIStemp = (XPathAPI.selectNodeList(doc, querie)).item(0).getNodeValue();
			querie = "//parent::XML/SINDICATOS/"+CTI+"/text()";
			codCTItemp = (XPathAPI.selectNodeList(doc, querie)).item(0).getNodeValue();
			querie = "//parent::XML/SINDICATOS/"+CSI+"/text()";
			codCSItemp = (XPathAPI.selectNodeList(doc, querie)).item(0).getNodeValue();
			querie = "//parent::XML/SINDICATOS/"+NOSIN+"/text()";
			codNOSINtemp = (XPathAPI.selectNodeList(doc, querie)).item(0).getNodeValue();
			querie = "//parent::XML/SINDICATOS/"+nomsindicato+"/text()";
			nodeNOMBRE = XPathAPI.selectNodeList(doc, querie);
		} catch (TransformerException e) {
			
			W83aClsTrazas.trazaError(null,e.getLocalizedMessage(),e);
		}
		return nodeNOMBRE.item(0).getNodeValue();
	}

	
	
	//TIPOS DE BSQUEDA ELECTORAL
	public static final String BUSQUEDA_ELECTORAL_ACTA = "A";
	public static final String BUSQUEDA_ELECTORAL_PREVISO = "P";
	public static final String BUSQUEDA_ELECTORAL_CENTRO = "C";
	
	public static final String BUSQUEDA_ELECTORAL_TIPO_ACTA = "ACTA";
	public static final String BUSQUEDA_ELECTORAL_TIPO_PREAVISO = "PREAVISO";
	public static final String BUSQUEDA_ELECTORAL_INCIDENCIA = "INCIDENCIA";
	public static final String BUSQUEDA_ELECTORAL_IMPUGNACION = "IMPUGNACION";
	
	//FLAG CONTROL LOTE FIRMADO
	public static final String LOTE_NO_FIRMADO = "0";
	public static final String LOTE_FIRMADO = "1";
	
}